package gov.va.med.mhv.sm.admin.data.enums;

import java.io.Serializable;
public enum UserTypeEnum implements Serializable {

	PATIENT (0L, "Patient"),
	CLINICIAN (1L, "Clinician"),
	ADMINISTRATOR(2L, "Administrator");
	
	
	private Long id;
	private String description;
	
	private UserTypeEnum(Long id, String description){
		this.id = id;
		this.description = description;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	
	public static UserTypeEnum valueOf(Long value){
		for(UserTypeEnum f : UserTypeEnum.values()){
			if(f.getId().equals(value))
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no user type found");
	}
	
	
}
